import { Link, useLocation } from 'react-router-dom'
import { TrendingUp } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-marketing">
      <header className="header-marketing">
        <div className="container">
          <div className="header-content-marketing">
            <Link to="/" className="logo-marketing">
              <div className="logo-icon-wrapper-marketing">
                <TrendingUp className="logo-icon-marketing" size={32} />
              </div>
              <span className="logo-text-marketing">MARKETPRO</span>
            </Link>
            <nav className="nav-marketing">
              <Link 
                to="/" 
                className={`nav-link-marketing ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои курсы
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-marketing ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-marketing">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

